<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Illuminate\Pagination\Paginator;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // Use Bootstrap 5 for pagination
        Paginator::useBootstrapFive();

        // Share locations and types data with all views
        View::composer('*', function ($view) {
            $locale = app()->getLocale() == 'hr' ? 'hr' : 'en';
            $cacheKey = "view_data_{$locale}";

            // Cache for 1 hour (3600 seconds)
            $data = cache()->remember($cacheKey, 3600, function () use ($locale) {
                // LOCATIONS
                $locations = DB::table('baza_locations_main')->get();
                $locations = $locations->map(function($location) use ($locale) {
                    return (object)[
                        'id' => $location->id,
                        'name' => $location->$locale,
                        'slug' => Str::slug($location->$locale),
                    ];
                });

                // TYPES
                $types = DB::table('baza_realestate_types')->get();
                $types = $types->map(function($type) use ($locale) {
                    return (object)[
                        'id' => $type->id,
                        'name' => $type->$locale,
                        'slug' => Str::slug($type->$locale),
                    ];
                });

                return [
                    'locations' => $locations,
                    'types' => $types,
                    'locale' => $locale
                ];
            });

            $view->with($data);
        });
    }
}
