@extends('app')
@section('title', __('about.page_title'))
@section('content')

<!-- Header Banner -->
<div class="banner-header section-padding valign bg-img bg-fixed" data-overlay-dark="4"
  data-background="{{asset('assets')}}/images/dubrovnik_cover.jpg">
  <div class="container">
    <div class="row">
      <div class="col-md-12 caption mt-90">
        <h5>{{ __('about.header_subtitle') }}</h5>
        <h1>{{ __('about.header_title') }}</h1>
      </div>
    </div>
  </div>
</div>

<!-- About Section -->
<section class="section-padding bg-darkgray">
  <div class="container">
    <div class="row">
      <!-- Main Content -->
      <div class="col-lg-8 mb-4 mb-lg-0 animate-box" data-animate-effect="fadeInUp">
        <div class="section-subtitle">{{ __('about.section_subtitle') }}</div>
        <h2 class="section-title mb-4">{{ __('about.section_title') }}</h2>

        <div class="lh-lg">
          <p class="fs-6 mb-4 fw-medium">{{ __('about.greeting') }}</p>
          <p class="mb-4">{{ __('about.intro') }}</p>
          <p class="mb-4">{{ __('about.paragraph_1') }}</p>
          <p class="mb-4">{{ __('about.paragraph_2') }}</p>
          <p class="mb-4">{{ __('about.paragraph_3') }}</p>
          <p class="mb-4">{{ __('about.paragraph_4') }}</p>
          <p class="mb-4">{{ __('about.paragraph_5') }}</p>
          <p class="mb-4">{{ __('about.paragraph_6') }}</p>
        </div>

        <!-- Contact CTA -->
        <div class="reservations mt-5">
          <div class="icon text-white"><span class="flaticon-call text-white"></span></div>
          <div class="text text-white">
            <p class="text-white mb-1">{{ __('about.contact_cta') }}</p>
            <a href="tel:+385020451800" class="text-white fs-5 fw-medium text-decoration-none">{{ __('about.phone') }}</a>
          </div>
        </div>
      </div>

      <!-- Company Info Sidebar -->
      <div class="col-lg-4 animate-box" data-animate-effect="fadeInUp">

        <!-- Contact Card -->
        <div class="bg-white bg-opacity-10 rounded-3 p-4 border border-white border-opacity-10 mb-4">
          <h5 class="fs-6 mb-3 text-uppercase fw-bold" style="letter-spacing: 1px;">{{ __('about.contact_info') }}</h5>
          <div class="text-white text-opacity-75 small lh-lg">
            <p class="mb-2"><i class="ti-location-pin me-2"></i> {{ __('about.address') }}</p>
            <p class="mb-2"><i class="ti-mobile me-2"></i> <a href="tel:+385020451800" class="text-white text-opacity-75 text-decoration-none">{{ __('about.phone') }}</a></p>
            <p class="mb-2"><i class="ti-email me-2"></i> <a href="mailto:info@imbnekretnine.hr" class="text-white text-opacity-75 text-decoration-none">{{ __('about.email') }}</a></p>
            <p class="mb-0"><i class="ti-world me-2"></i> <a href="http://www.imbnekretnine.hr/" target="_blank" class="text-white text-opacity-75 text-decoration-none">{{ __('about.website') }}</a></p>
          </div>
        </div>

        <!-- Quick Facts -->
        <div class="bg-white bg-opacity-10 rounded-3 p-4 border border-white border-opacity-10 mb-4">
          <h5 class="fs-6 mb-3 text-uppercase fw-bold" style="letter-spacing: 1px;">{{ __('about.quick_facts') }}</h5>
          <div class="text-white text-opacity-75 small">
            <div class="d-flex justify-content-between py-2 border-bottom border-white border-opacity-10">
              <span class="text-white text-opacity-50">{{ __('about.founded') }}</span>
              <span class="fw-medium">{{ __('about.founded_year') }}</span>
            </div>
            <div class="d-flex justify-content-between py-2 border-bottom border-white border-opacity-10">
              <span class="text-white text-opacity-50">{{ __('about.employees') }}</span>
              <span class="fw-medium">{{ __('about.employees_count') }}</span>
            </div>
            <div class="d-flex justify-content-between py-2 border-bottom border-white border-opacity-10">
              <span class="text-white text-opacity-50">{{ __('about.mb') }}</span>
              <span class="fw-medium">{{ __('about.mb_number') }}</span>
            </div>
            <div class="d-flex justify-content-between py-2 border-bottom border-white border-opacity-10">
              <span class="text-white text-opacity-50">{{ __('about.oib') }}</span>
              <span class="fw-medium">{{ __('about.oib_number') }}</span>
            </div>
            <div class="d-flex justify-content-between py-2">
              <span class="text-white text-opacity-50">{{ __('about.mbs') }}</span>
              <span class="fw-medium">{{ __('about.mbs_number') }}</span>
            </div>
          </div>
        </div>

        <!-- Legal Info -->
        <div class="bg-white bg-opacity-10 rounded-3 p-4 border border-white border-opacity-10">
          <h5 class="fs-6 mb-3 text-uppercase fw-bold" style="letter-spacing: 1px;">{{ __('about.legal_info') }}</h5>
          <div class="text-white text-opacity-75 small lh-lg">
            <div class="mb-3">
              <strong class="text-white text-opacity-50 d-block mb-1">{{ __('about.service') }}</strong>
              {{ __('about.service_text') }}
            </div>
            <div class="mb-3">
              <strong class="text-white text-opacity-50 d-block mb-1">{{ __('about.court') }}</strong>
              {{ __('about.court_text') }}
            </div>
            <div class="mb-3">
              <strong class="text-white text-opacity-50 d-block mb-1">{{ __('about.headquarters') }}</strong>
              {{ __('about.headquarters_text') }}
            </div>
            <div class="mb-3">
              <strong class="text-white text-opacity-50 d-block mb-1">{{ __('about.capital') }}</strong>
              {{ __('about.capital_text') }}
            </div>
            <div class="mb-3">
              <strong class="text-white text-opacity-50 d-block mb-1">{{ __('about.bank') }}</strong>
              {{ __('about.bank_text') }}<br>
              {{ __('about.iban') }}<br>
              {{ __('about.swift') }}
            </div>
            <div>
              <strong class="text-white text-opacity-50 d-block mb-1">{{ __('about.representatives') }}</strong>
              {{ __('about.representatives_text') }}
            </div>
          </div>
        </div>

      </div>
    </div>
    <!-- Map Section -->
    <div class="row" style="margin-top: 50px;">
        <div class="col-md-12 map animate-box" data-animate-effect="fadeInUp">
            <iframe src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d366.80526923218855!2d18.0913257!3d42.6519848!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x134c75291228f7bb%3A0x4cc7a62974cda59d!2sIMB%20Real%20Estate!5e0!3m2!1sen!2sbd!4v1762788594777!5m2!1sen!2sbd" width="100%" height="600" style="border:0;" allowfullscreen="" loading="lazy"></iframe>
        </div>
    </div>
  </div>
</section>
@endsection