@extends('app')
@section('title', 'Contact Us')
@section('content')
  <!-- Header Banner -->
  <div class="banner-header section-padding valign bg-img bg-fixed" data-overlay-dark="3" data-background="{{asset('assets')}}/images/dubrovnik_cover.jpg">
    <div class="container">
        <div class="row">
            <div class="col-md-12 text-left caption mt-90">
                <h5>Get in touch</h5>
                <h1>Contact Us</h1>
            </div>
        </div>
    </div>
</div>
<!-- Contact -->
<section class="contact section-padding bg-darkgray">
    <div class="container">
        <div class="row mb-90">
            <div class="col-md-6 mb-60">
                <h3>IMB Real Estate Ltd. Dubrovnik</h3>
                <p>{{ __('app.contact_intro') }}</p>
                <div class="reservations mb-30">
                    <div class="icon"><span class="flaticon-call text-white"></span></div>
                    <div class="text ">
                        <p>{{ __('app.phone') }}</p>
                        <a class="text-white" href="tel:385204518000">+385 20 451 800</a><br>
                    </div>
                </div>
                <div class="reservations mb-30">
                    <div class="icon"><span class="flaticon-envelope text-white"></span></div>
                    <div class="text">
                        <p>{{ __('app.email') }}</p>
                        <a class="text-white" href="mailto:info@imbnekretnine.hr">info@imbnekretnine.hr</a><br>
                        <a class="text-white" href="mailto:nada@imbnekretnine.hr">nada@imbnekretnine.hr</a>
                    </div>
                </div>
                <div class="reservations mb-30">
                    <div class="icon"><span class="flaticon-globe text-white"></span></div>
                    <div class="text">
                        <p>{{ __('app.website') }}</p>
                        <a class="text-white" href="https://www.imbnekretnine.hr" target="_blank">www.imbnekretnine.hr</a><br>
                        <a class="text-white" href="https://www.dubrovnik-realestate.com" target="_blank">www.dubrovnik-realestate.com</a>
                    </div>
                </div>
                <div class="reservations">
                    <div class="icon"><span class="flaticon-location-pin text-white"></span></div>
                    <div class="text">
                        <p>{{ __('app.address') }}</p>
                        Vukovarska 30, 20000 Dubrovnik, Croatia<br>
                        <small>({{ __('app.ground_floor_duhan') }})</small>
                    </div>
                </div>
            </div>
            <div class="col-md-5 mb-30 offset-md-1">
                <h3>{{ __('app.get_in_touch') }}</h3>
                <form method="post" class="contact__form" action="{{ route('contact.submit') }}">
                    @csrf
                    <!-- form message -->
                    <div class="row">
                        <div class="col-12">
                            <div class="alert alert-success contact__msg" role="alert"></div>
                        </div>
                    </div>
                    <!-- form elements -->
                    <div class="row">
                        <div class="col-md-6 form-group">
                            <input name="name" type="text" placeholder="{{ __('app.your_name') }}" value="{{ old('name') }}" required>
                        </div>
                        <div class="col-md-6 form-group">
                            <input name="email" type="email" placeholder="{{ __('app.your_email') }}" value="{{ old('email') }}" required>
                        </div>
                        <div class="col-md-6 form-group">
                            <input name="phone" type="text" placeholder="{{ __('app.your_phone') }}" value="{{ old('phone') }}" required>
                        </div>
                        <div class="col-md-6 form-group">
                            <input name="subject" type="text" placeholder="{{ __('app.subject') }}" value="{{ old('subject') }}" required>
                        </div>
                        <div class="col-md-12 form-group">
                            <textarea name="message" id="message" cols="30" rows="4" placeholder="{{ __('app.message') }}" required>{{ old('message') }}</textarea>
                        </div>
                        <div class="col-md-12">
                            <button type="submit" class="butn-dark2"><span>{{ __('app.send_message') }}</span></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <!-- Map Section -->
        <div class="row">
            <div class="col-md-12 map animate-box" data-animate-effect="fadeInUp">
                <iframe src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d366.80526923218855!2d18.0913257!3d42.6519848!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x134c75291228f7bb%3A0x4cc7a62974cda59d!2sIMB%20Real%20Estate!5e0!3m2!1sen!2sbd!4v1762788594777!5m2!1sen!2sbd" width="100%" height="600" style="border:0;" allowfullscreen="" loading="lazy"></iframe>
            </div>
        </div>
    </div>
</section>
@endsection