<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Property Inquiry - IMB Real Estate</title>
    <style>
        /* Reset styles for email clients */
        body, table, td, p, a, li, blockquote {
            -webkit-text-size-adjust: 100%;
            -ms-text-size-adjust: 100%;
        }
        table, td {
            mso-table-lspace: 0pt;
            mso-table-rspace: 0pt;
        }
        img {
            -ms-interpolation-mode: bicubic;
            border: 0;
            outline: none;
            text-decoration: none;
        }
        
        /* Main styles */
        body {
            margin: 0;
            padding: 0;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            font-size: 16px;
            line-height: 1.6;
            color: #333333;
            background-color: #f5f5f5;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
        }
        
        .email-wrapper {
            width: 100%;
            background-color: #f5f5f5;
            padding: 40px 0;
        }
        
        .email-container {
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        }
        
        .email-header {
            background-color: #710001;
            color: #ffffff;
            padding: 40px 30px;
            text-align: center;
        }
        
        .email-header h1 {
            margin: 0;
            font-size: 28px;
            font-weight: 600;
            letter-spacing: -0.5px;
            color: #ffffff;
        }
        
        .email-header .subtitle {
            margin: 8px 0 0 0;
            font-size: 14px;
            opacity: 0.9;
            font-weight: 400;
        }
        
        .email-body {
            padding: 40px 30px;
        }
        
        .intro-text {
            font-size: 16px;
            color: #666666;
            margin: 0 0 30px 0;
            line-height: 1.7;
        }
        
        .info-section {
            background-color: #fafafa;
            border-left: 4px solid #710001;
            padding: 20px;
            margin-bottom: 20px;
            border-radius: 4px;
        }
        
        .info-section:last-child {
            margin-bottom: 0;
        }
        
        .info-label {
            font-size: 12px;
            font-weight: 600;
            color: #710001;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin: 0 0 8px 0;
        }
        
        .info-value {
            font-size: 16px;
            color: #333333;
            margin: 0;
            line-height: 1.6;
            word-wrap: break-word;
        }
        
        .message-section {
            background-color: #ffffff;
            border: 1px solid #e0e0e0;
            border-left: 4px solid #710001;
            padding: 20px;
            margin-top: 20px;
            border-radius: 4px;
        }
        
        .message-content {
            font-size: 15px;
            color: #444444;
            line-height: 1.7;
            white-space: pre-wrap;
            word-wrap: break-word;
        }
        
        .divider {
            height: 1px;
            background-color: #e0e0e0;
            margin: 30px 0;
            border: none;
        }
        
        .email-footer {
            background-color: #fafafa;
            padding: 30px;
            text-align: center;
            border-top: 1px solid #e0e0e0;
        }
        
        .email-footer p {
            margin: 8px 0;
            font-size: 13px;
            color: #888888;
            line-height: 1.6;
        }
        
        .email-footer .company-name {
            font-weight: 600;
            color: #710001;
        }
        
        /* Responsive styles */
        @media only screen and (max-width: 600px) {
            .email-wrapper {
                padding: 20px 0;
            }
            
            .email-header,
            .email-body,
            .email-footer {
                padding: 25px 20px;
            }
            
            .email-header h1 {
                font-size: 24px;
            }
            
            .info-section {
                padding: 15px;
            }
        }
    </style>
</head>
<body>
    <div class="email-wrapper">
        <div class="email-container">
            <!-- Header -->
            <div class="email-header">
                <h1>New Property Inquiry</h1>
                <p class="subtitle">IMB Real Estate</p>
            </div>
            
            <!-- Body -->
            <div class="email-body">
                <p class="intro-text">
                    You have received a new inquiry for a property listing. Please find the details below:
                </p>
                
                <!-- Property Information -->
                <div class="info-section">
                    <div class="info-label">Property</div>
                    <div class="info-value">
                        <strong>{{ $property_title }}</strong><br>
                        <span style="font-size: 14px; color: #888;">Property ID: {{ $property_id }}</span>
                    </div>
                </div>
                
                <!-- Contact Information -->
                <div class="info-section">
                    <div class="info-label">Contact Information</div>
                    <div class="info-value">
                        <strong>{{ $name }}</strong><br>
                        <a href="mailto:{{ $email }}" style="color: #710001; text-decoration: none;">{{ $email }}</a><br>
                        <a href="tel:{{ $phone }}" style="color: #710001; text-decoration: none;">{{ $phone }}</a>
                    </div>
                </div>
                
                <!-- Message -->
                @if(!empty($inquiry_message))
                <div class="message-section">
                    <div class="info-label">Message</div>
                    <div class="message-content">{{ $inquiry_message }}</div>
                </div>
                @endif
            </div>
            
            <!-- Footer -->
            <div class="email-footer">
                <p>This inquiry was submitted through the <span class="company-name">IMB Real Estate</span> website.</p>
                <p>&copy; {{ date('Y') }} IMB Real Estate. All rights reserved.</p>
            </div>
        </div>
    </div>
</body>
</html>
