@extends('app')
@section('title', $property->title . ' - ' . __('app.site_title'))
@section('content')

@php
    $images = getAllImages($property->company_id, $property->id);
    $mainImage = getMainImage($property->company_id, $property->id);
    $fallbackImage = asset('assets/images/dubrovnik1.jpg');
@endphp

 <!-- Slider -->
 <header class="header slider-fade">
    <div class="owl-carousel owl-theme">
        @forelse(array_slice($images, 0, 5) as $image)
        <!-- The opacity on the image is made with "data-overlay-dark="number". You can change it using the numbers 0-9. -->
        <div class="text-center item bg-img" data-overlay-dark="2" data-background="{{ $image }}">
            <div class="v-middle caption">
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-md-10 col-md-12">
                           
                            <h1 class="fs-2">{{ $property->title }}</h1>
                            <div class="butn-light mt-30 mb-30"> <a href="#" data-scroll-nav="1"><span><i class="ti-arrow-down"></i> {{ __('app.explore') }}</span></a> </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @empty
        <div class="text-center item bg-img" data-overlay-dark="2" data-background="{{ $fallbackImage }}">
            <div class="v-middle caption">
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-md-10 col-md-12">
                            <h1 class="fs-2">{{ $property->title }}</h1>
                            <div class="butn-light mt-30 mb-30"> <a href="#" data-scroll-nav="1"><span><i class="ti-arrow-down"></i> {{ __('app.explore') }}</span></a> </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @endforelse
    </div>
    <!-- slider reservation -->
    <div class="reservation">
        <a href="tel:+38520451800">
            <div class="icon d-flex justify-content-center align-items-center">
                <i class="flaticon-call"></i>
            </div>
            <div class="call "><span class="text-white">+385 20 451 800</span> <br>{{ __('app.contact_us') }}</div>
        </a>
    </div>
  
</header>

<!-- Property Content -->
<section class="rooms-page section-padding bg-darkgray" data-scroll-index="1">
    <div class="container">
        <div class="row">
            <!-- Left Column - Property Details -->
            <div class="col-lg-7">
                <div class="section-subtitle">{{ $property->location_main ?? __('app.luxury_property') }}</div>
                <div class="section-title">{{ $property->title }}</div>

                <!-- Description -->
                <div class="mb-30">
                    @if(empty($property->description))
                        <p>{{ __('app.no_description') }}</p>
                    @else
                    {!! nl2br(e($property->description)) !!}
                    @endif
                </div>
            </div>

            <!-- Right Column - Property Summary -->
            <div class="col-lg-5">
                <div class="booking-box">
                    <div class="head-box">
                        <h4>{{ __('app.property_summary') }}</h4>
                    </div>
                    <div class="booking-inner clearfix">
                        <ul class="list-unstyled page-list">
                                <li>
                                    <div class="page-list-icon"> <span class="ti-money"></span> </div>
                                    <div class="page-list-text">
                                        <strong>{{ __('app.price') }}:</strong>
                                        <span class="badge bg-darkgray">{{__('app.on_request')}}</span>
                                    </div>
                                </li>
                                <li>
                                    <div class="page-list-icon"> <span class="ti-tag"></span> </div>
                                    <div class="page-list-text">
                                        <strong>{{ __('app.property_type') }}:</strong>
                                        <p>{{ $property->type_name }}</p>
                                    </div>
                                </li>
                            @if($property->area)
                                <li>
                                    <div class="page-list-icon"> <span class="flaticon-clock-1"></span> </div>
                                    <div class="page-list-text">
                                        <strong>{{ __('app.area') }}:</strong>
                                        <p>{{ number_format($property->area) }} m²</p>
                                    </div>
                                </li>
                            @endif
                            @if($property->view)
                                <li>
                                    <div class="page-list-icon"> <span class="ti-eye"></span> </div>
                                    <div class="page-list-text">
                                        <strong>{{ __('app.view') }}:</strong>
                                        <p class="text-capitalize">{{ str_replace(';', ', ', $property->view) }}</p>
                                    </div>
                                </li>
                            @endif
                            @if($property->bedrooms)
                                <li>
                                    <div class="page-list-icon"> <span class="flaticon-bed"></span> </div>
                                    <div class="page-list-text">
                                        <strong>{{ __('app.bedrooms') }}:</strong>
                                        <p>{{ $property->bedrooms }}</p>
                                    </div>
                                </li>
                            @endif
                            @if($property->bathrooms)
                                <li>
                                    <div class="page-list-icon"> <span class="flaticon-bath"></span> </div>
                                    <div class="page-list-text">
                                        <strong>{{ __('app.bathrooms') }}:</strong>
                                        <p>{{ $property->bathrooms }}</p>
                                    </div>
                                </li>
                            @endif
                            @if($property->parking)
                                <li>
                                    <div class="page-list-icon"> <span class="ti-car"></span> </div>
                                    <div class="page-list-text">
                                        <strong>{{ __('app.parking') }}:</strong>
                                        <p>{{ $property->parking }}</p>
                                    </div>
                                </li>
                            @endif
                            <li>
                                <div class="page-list-icon"> <span class="ti-location-pin"></span> </div>
                                <div class="page-list-text">
                                    <strong>{{ __('app.location') }}:</strong>
                                    <p>{{ $property->location_name ?? 'Dubrovnik' }}</p>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>

               
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                {{-- gallery view of the property --}}
                <!--div class="head-box mt-4">
                    <h4>{{ __('app.gallery') }}</h4>
                </div-->
                <div class="gallery-view">
                    @php
                        $totalImages = count($images);
                        $displayLimit = 6;
                        $remainingCount = $totalImages > $displayLimit ? $totalImages - $displayLimit : 0;
                    @endphp
                    @foreach ($images as $index => $image)
                        <div class="gallery-view-item {{ $index >= $displayLimit ? 'gallery-view-item-hidden' : '' }} {{ $index == ($displayLimit - 1) && $remainingCount > 0 ? 'gallery-view-item-last' : '' }}">
                            <a href="{{ $image }}" class="gallery-view-link">
                                <img src="{{ $image }}" alt="{{ $property->title }}">
                                <div class="gallery-view-overlay">
                                    <i class="ti-zoom-in"></i>
                                </div>
                                @if($index == ($displayLimit - 1) && $remainingCount > 0)
                                    <div class="gallery-view-more-overlay">
                                        <span class="gallery-view-more-text">+{{ $remainingCount }}</span>
                                        <span class="gallery-view-more-label">{{ __('app.more_images') }}</span>
                                    </div>
                                @endif
                            </a>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
        <div class="row">
            <div col="col-md-12">
                @php
                    $embedUrl = getYoutubeEmbedUrl($property->youtube_link ?? null);
                @endphp
                @if($embedUrl)
                <div class="mb-30">
                    <!--h5 class="mb-3">{{ __('app.video') }}</h5-->
                    <div class="video-container" style="margin-top: 50px; position: relative; padding-bottom: 56.25%; height: 0; overflow: hidden; max-width: 100%; background: #000;">
                        <iframe
                            src="{{ $embedUrl }}"
                            style="position: absolute; top: 0; left: 0; width: 100%; height: 100%;"
                            frameborder="0"
                            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                            allowfullscreen>
                        </iframe>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>
</section>

<!-- Contact Agent Section -->
<section class="property-agent">
    <div class="bg-darkgray px-4"  data-overlay-dark="2">
        <div class="container">
            <div class="row">
                <!-- Agent Details -->
                <div class="col-md-7 mb-30 mt-30">
                    <div class="agent-contact-info">
                        <h3>{{ __('app.contact_agent') }}</h3>
                        <!--h4>IMB Real Estate</h4-->
                        <hr>
                        <p>{{ __('app.contact_intro') }}</p>
                        <hr>
                        <dl>
                            <dt>{{ __('app.email') }}:</dt>
                            <dd><a href="mailto:info@imbnekretnine.hr">info@imbnekretnine.hr</a></dd>
                            <dt>{{ __('app.phone') }}:</dt>
                            <dd><a href="tel:+38591333480">+385 91 333 5480</a></dd>
                            <dd><a href="tel:+38591331480">+385 91 331 5480</a></dd>
                        </dl>
                    </div>
                </div>

                <!-- Contact Form -->
                <div class="col-md-5">
                    <div class="booking-box">
                        <div class="head-box">
                            <h4>{{ __('app.property_inquiry') }}</h4>
                        </div>
                        <div class="booking-inner clearfix">
                            @if(session('success'))
                                <div class="alert alert-success">
                                    {{ session('success') }}
                                </div>
                            @endif
                            @if(session('error'))
                                <div class="alert alert-danger">
                                    {{ session('error') }}
                                </div>
                            @endif

                            @if($errors->any())
                                <div class="alert alert-danger">
                                    <ul class="mb-0">
                                        @foreach($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif

                            <form action="{{ route('property.contact') }}" method="POST" class="form1 clearfix">
                                @csrf
                                <input type="hidden" name="property_id" value="{{ $property->id }}">
                                <input type="hidden" name="property_title" value="{{ $property->title }}">

                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="input1_wrapper">
                                            <label>{{ __('app.your_name') }}</label>
                                            <div class="input_inner">
                                                <input type="text" name="name" class="form-control input" placeholder="{{ __('app.your_name') }}" value="{{ old('name') }}" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="input1_wrapper">
                                            <label>{{ __('app.your_email') }}</label>
                                            <div class="input_inner">
                                                <input type="email" name="email" class="form-control input" placeholder="{{ __('app.your_email') }}" value="{{ old('email') }}" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="input1_wrapper">
                                            <label>{{ __('app.your_phone') }}</label>
                                            <div class="input_inner">
                                                <input type="text" name="phone" class="form-control input" placeholder="{{ __('app.your_phone') }}" value="{{ old('phone') }}" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="input1_wrapper">
                                            <label>{{ __('app.message') }}</label>
                                            <div class="input_inner">
                                                <textarea name="message" class="form-control input" rows="4" placeholder="{{ __('app.message') }}" required>{{ old('message') }}</textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <button type="submit" class="btn-form1-submit mt-15">{{ __('app.send_message') }}</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Similar Properties -->
@if(isset($similarProperties) && $similarProperties->count() > 0)
<section class="rooms1 section-padding bg-darkgray">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="section-subtitle"><span>{{ __('app.similar_properties') }}</span></div>
                <div class="section-title">{{ __('app.you_might_also_like') }}</div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="owl-carousel owl-theme">
                    @foreach($similarProperties as $property)
                    @include('property.card', ['property' => $property])

                    @endforeach
                </div>
            </div>
        </div>
    </div>
</section>
@endif
<!-- Map Section -->
<div class="row">
    <div class="col-md-12 map animate-box" data-animate-effect="fadeInUp">
        <iframe src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d366.80526923218855!2d18.0913257!3d42.6519848!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x134c75291228f7bb%3A0x4cc7a62974cda59d!2sIMB%20Real%20Estate!5e0!3m2!1sen!2sbd!4v1762788594777!5m2!1sen!2sbd" width="100%" height="600" style="border:0;" allowfullscreen="" loading="lazy"></iframe>
    </div>
</div>

@endsection
