@extends('app')
@section('title', __('app.site_title'))
@section('content')
<!-- Header Video -->
<!-- Booking Search -->
<div class="search-wrapper">
  <div class="search-wrapper-inner">
      <div class="container">
        <div class="row">
          <div class="col-md-10 offset-md-1 text-center"> 
              <h1>{{ __('home.hero_title') }}</h1>
              <h4>{{ __('home.hero_subtitle') }}</h4>
          </div>
      </div>
          <div class="booking-inner clearfix">
              <form action="{{ route('search.'.$locale) }}" method="GET" class="form1 clearfix">
                  <div class="col2 c3">
                      <div class="input1_wrapper">
                          <div class="input1_inner">
                              <input type="text" class="form-control input" placeholder="{{ __('home.search_placeholder') }}" name="query" value="{{ $search_query }}">
                          </div>
                      </div>
                  </div>
                  <div class="col2 c3">
                      <div class="select1_wrapper">
                          <label>{{ __('home.search_location') }}</label>
                          <div class="select1_inner">
                              <select class="select2 select" style="width: 100%" name="location" value="{{ $location }}">
                                  <option value="">{{ __('home.search_location_select') }}</option>
                                  @foreach($locations as $item)
                                      <option value="{{ $item->slug }}" {{ $item->slug == $location ? 'selected' : '' }}>{{ $item->name }}</option>
                                  @endforeach
                              </select>
                          </div>
                      </div>
                  </div>
                  <div class="col2">
                      <div class="select1_wrapper">
                          <label>{{ __('home.search_type') }}</label>
                          <div class="select1_inner">
                              <select class="select2 select" style="width: 100%" name="type" value="{{ $type }}">
                                  <option value="">{{ __('home.search_type_select') }}</option>
                                  @foreach($types as $key => $item)
                                      <option value="{{ $item->slug }}" {{ $item->slug == $type ? 'selected' : '' }}>{{  $item->name }}</option>
                                  @endforeach
                              </select>
                          </div>
                      </div>
                  </div>
                  <div class="col2">
                      <button type="submit" class="btn-form1-submit">{{ __('home.search_button') }}</button>
                  </div>
              </form>
          </div>
      </div>
      </div>
</div>

<!-- Rooms -->
<section class="rooms1 py-5 bg-darkgray" data-scroll-index="1">
  <div class="container-fluid">
      
      <div class="row">
          @forelse($properties as $key => $property)
          <div class="col-md-{{ ($key % 5) ? '3' : '6' }}">
            @include('property.card', ['property' => $property])
          </div>
          @empty
          <div class="col-md-12 text-center">
              <span class="text-white text-center">{{ __('home.no_properties_found') }}</span>
          </div>
          @endforelse
         
       

          @if(count($properties) > 0)
          <div class="col-md-12">
              <div class="d-flex justify-content-center mt-4 mb-5">
                  {{ $properties->links() }}
              </div>
          </div>
          @endif
      </div>
  </div>
</section>


@endsection